<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\LeaderAssessment;
use App\Http\Models\People as Person;
use App\Http\Models\User;
use Illuminate\Http\Request;
use Exception;

class LeaderAssessmentsController extends Controller
{

    /**
     * Display a listing of the leader assessments.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $leaderAssessments = LeaderAssessment::with('person','user')->paginate(25);

        return view('leader_assessments.index', compact('leaderAssessments'));
    }

    /**
     * Show the form for creating a new leader assessment.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        $people = Person::pluck('name','id')->all();
        $users = User::pluck('name','id')->all();        
        return view('leader_assessments.create', compact('people','users'));
    }

    /**
     * Store a new leader assessment in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            LeaderAssessment::create($data);

            return redirect()->route('leader_assessments.leader_assessment.index')
                ->with('success_message', 'เพิ่ม Leader Assessment ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified leader assessment.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $leaderAssessment = LeaderAssessment::with('person','user')->findOrFail($id);

        return view('leader_assessments.show', compact('leaderAssessment'));
    }

    /**
     * Show the form for editing the specified leader assessment.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $leaderAssessment = LeaderAssessment::findOrFail($id);
        $people = Person::pluck('name','id')->all();
$users = User::pluck('name','id')->all();

        return view('leader_assessments.edit', compact('leaderAssessment','people','users'));
    }

    /**
     * Update the specified leader assessment in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $leaderAssessment = LeaderAssessment::findOrFail($id);
            $leaderAssessment->update($data);

            return redirect()->route('leader_assessments.leader_assessment.index')
                ->with('success_message', 'ปรับปรุงข้อมูล Leader Assessment เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified leader assessment from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $leaderAssessment = LeaderAssessment::findOrFail($id);
            $leaderAssessment->delete();

            return redirect()->route('leader_assessments.leader_assessment.index')
                ->with('success_message', 'ลบข้อมูล Leader Assessment เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'people_id' => 'nullable',
            'assessment_date' => 'nullable|string|min:0',
            'assessment_period' => 'nullable',
            'expression' => 'nullable',
            'performance' => 'nullable',
            'dependability' => 'nullable',
            'associate' => 'nullable',
            'users_id' => 'nullable', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }

}
