<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\Position;
use Illuminate\Http\Request;
use Exception;

class PositionsController extends Controller
{

    /**
     * Display a listing of the positions.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $positions = Position::paginate(25);

        return view('positions.index', compact('positions'));
    }

    /**
     * Show the form for creating a new position.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        
        
        return view('positions.create');
    }

    /**
     * Store a new position in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            Position::create($data);

            return redirect()->route('positions.position.index')
                ->with('success_message', 'เพิ่ม Position ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified position.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $position = Position::findOrFail($id);

        return view('positions.show', compact('position'));
    }

    /**
     * Show the form for editing the specified position.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $position = Position::findOrFail($id);
        

        return view('positions.edit', compact('position'));
    }

    /**
     * Update the specified position in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $position = Position::findOrFail($id);
            $position->update($data);

            return redirect()->route('positions.position.index')
                ->with('success_message', 'ปรับปรุงข้อมูล Position เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified position from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $position = Position::findOrFail($id);
            $position->delete();

            return redirect()->route('positions.position.index')
                ->with('success_message', 'ลบข้อมูล Position เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'name' => 'nullable|string|min:0|max:50', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }

}
