<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Home extends Model
{
    

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'homes';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'electorates_id',
                  'amphurs_id',
                  'tambons_id',
                  'moobans_id',
                  'address',
                  'users_id',
                  'remark'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the electorate for this model.
     *
     * @return App\Http\Models\Electorate
     */
    public function electorate()
    {
        return $this->belongsTo('App\Http\Models\Electorate','electorates_id');
    }

    /**
     * Get the amphur for this model.
     *
     * @return App\Http\Models\Amphur
     */
    public function amphur()
    {
        return $this->belongsTo('App\Http\Models\Amphur','amphurs_id');
    }

    /**
     * Get the tambon for this model.
     *
     * @return App\Http\Models\Tambon
     */
    public function tambon()
    {
        return $this->belongsTo('App\Http\Models\Tambon','tambons_id');
    }

    /**
     * Get the mooban for this model.
     *
     * @return App\Http\Models\Mooban
     */
    public function mooban()
    {
        return $this->belongsTo('App\Http\Models\Mooban','moobans_id');
    }

    /**
     * Get the user for this model.
     *
     * @return App\Http\Models\User
     */
    public function user()
    {
        return $this->belongsTo('App\Http\Models\User','users_id');
    }


    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

}
