<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Mooban extends Model
{
    

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'moobans';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'tambons_id',
                  'name',
                  'moo',
                  'man',
                  'woman',
                  'total_pop',
                  'total_house',
                  'mooban_statuses_id',
                  'latitude',
                  'longitude',
                  'mom_foudation'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the tambon for this model.
     *
     * @return App\Http\Models\Tambon
     */
    public function tambon()
    {
        return $this->belongsTo('App\Http\Models\Tambon','tambons_id');
    }

    /**
     * Get the moobanStatus for this model.
     *
     * @return App\Http\Models\MoobanStatus
     */
 

    public function user()
    {
        return $this->belongsTo('App\Http\Models\User','users_id');
    }
    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

}
