<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Tambon extends Model
{
    
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'tambons';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'amphurs_id',
                  'name',
                  'electorates_id'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the amphur for this model.
     *
     * @return App\Http\Models\Amphur
     */
    public function amphur()
    {
        return $this->belongsTo('App\Http\Models\Amphur','amphurs_id');
    }

    /**
     * Get the electorate for this model.
     *
     * @return App\Http\Models\Electorate
     */
    public function electorate()
    {
        return $this->belongsTo('App\Http\Models\Electorate','electorates_id');
    }



}
