<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use View;
use App\Http\Controllers\ThaiController;
use App\Http\Models\CustomModel;
use Illuminate\Pagination\Paginator;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
       if(env('APP_ENV')!='local'){
		     $this->app['request']->server->set('HTTPS', true);
		  }
		 
		Paginator::useBootstrap();
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        
		$thai = new ThaiController;
		$version = date('Ymd');
    
		View::share('thai',$thai);
		View::share('version',$version);
		 
         
    }
}
