@extends('layouts.app')

@section('content')

    @if(Session::has('success_message'))
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            {!! session('success_message') !!}

            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    @endif

    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">อำเภอ</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="{{ route('amphurs.amphur.create') }}" class="btn btn-success" title="เพิ่ม อำเภอ ใหม่">                     
					<i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>
        
        @if(count($amphurs) == 0)
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล อำเภอ</h4>
            </div>
        @else
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                        <tr>
						<th>ลำดับที่</th>
                                <th>รหัสจังหวัด</th>
                            <th>ชื่ออำเภอ </th>
                

                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
					 <?php $r = 0 ; if(isset($_REQUEST['page']) && $_REQUEST['page'] > 1 ){$r = 25 * ($_REQUEST['page']-1);}?>
                    @foreach($amphurs as $amphur)
                        <tr>
						<td>{{++$r}}</td>
						
                                <td>{{ optional($amphur->province)->name }}</td>
                            <td>{{ $amphur->name_th }}</td>
                       

                            <td>

                                <form method="POST" action="{!! route('amphurs.amphur.destroy', $amphur->id) !!}" accept-charset="UTF-8">
                                <input name="_method" value="DELETE" type="hidden">
                                {{ csrf_field() }}

                                    <div class="btn-group btn-group-sm float-right" role="group">
                                        <a href="{{ route('amphurs.amphur.show', $amphur->id ) }}" class="btn btn-info" title="แสดงข้อมูล อำเภอ">
                                            <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                        </a>
                                        <a href="{{ route('amphurs.amphur.edit', $amphur->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล อำเภอ">
                                            <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                        </a>

                                        <button type="submit" class="btn btn-danger" title="ลบ อำเภอ ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ อำเภอ ')">
                                            <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                        </button>
                                    </div>

                                </form>
                                
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>
        </div>

        <div class="card-footer">
            {!! $amphurs->render() !!}
        </div>
        
        @endif
    
    </div>
@endsection