@extends('layouts.app')

@section('content')

    <div class="card">
  
        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">{{ !empty($associate->name) ? $associate->name : 'Associate' }}</h5>

            <div class="btn-group btn-group-sm float-right" role="group">

                <a href="{{ route('associates.associate.index') }}" class="btn btn-primary" title="แสดง Associate ทั้งหมด">
                    <i class=" fas fa-fw fa-th-list" aria-hidden="true"></i>
                </a>

                <a href="{{ route('associates.associate.create') }}" class="btn btn-success" title="เพิ่ม Associate ใหม่">
                    <i class=" fas fa-fw fa-plus" aria-hidden="true"></i>
                </a>

            </div>
        </div>

        <div class="card-body">

            @if ($errors->any())
                <ul class="alert alert-danger">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            @endif

            <form method="POST" action="{{ route('associates.associate.update', $associate->id) }}" id="edit_associate_form" name="edit_associate_form" accept-charset="UTF-8" class="form-horizontal">
            {{ csrf_field() }}
            <input name="_method" type="hidden" value="PUT">
            @include ('associates.form', [
                                        'associate' => $associate,
                                      ])

                <div class="form-group">
                    <div align="center">
					<button class="btn btn-primary" type="submit">
					<i class="fas fa-fw fa-edit"></i> 
					ปรับปรุงข้อมูล</button>
					<button class="btn btn-light" type="reset">
					<i class="fas fa-fw fa-redo" aria-hidden="true"></i> 
					ยกเลิก</button>
				  </div>
                </div>
            </form>

        </div>
    </div>

@endsection