@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($associate->name) ? $associate->name : 'Associate' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('associates.associate.destroy', $associate->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('associates.associate.index') }}" class="btn btn-primary" title="แสดง Associate ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('associates.associate.create') }}" class="btn btn-success" title="เพิ่ม Associate ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('associates.associate.edit', $associate->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล Associate">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ Associate ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ Associate ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">ฝ่าย</div>
				<div class="col-sm-8">: {{ $associate->name }}</div>
			</div>

        

    </div>
</div>

@endsection