@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($education->name) ? $education->name : 'Education' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('educations.education.destroy', $education->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('educations.education.index') }}" class="btn btn-primary" title="แสดง Education ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('educations.education.create') }}" class="btn btn-success" title="เพิ่ม Education ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('educations.education.edit', $education->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล Education">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ Education ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ Education ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">ระดับการศึกษา</div>
				<div class="col-sm-8">: {{ $education->name }}</div>
			</div>

        

    </div>
</div>

@endsection