@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($title) ? $title : 'บ้านเลขที่' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('homes.home.destroy', $home->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('homes.home.index') }}" class="btn btn-primary" title="แสดง บ้านเลขที่ ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('homes.home.create') }}" class="btn btn-success" title="เพิ่ม บ้านเลขที่ ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('homes.home.edit', $home->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล บ้านเลขที่">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ บ้านเลขที่ ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ บ้านเลขที่ ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">เขตเลือกตั้ง</div>
				<div class="col-sm-8">: {{ optional($home->electorate)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">อำเภอ</div>
				<div class="col-sm-8">: {{ optional($home->amphur)->name_th }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ตำบล</div>
				<div class="col-sm-8">: {{ optional($home->tambon)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">หมู่บ้าน</div>
				<div class="col-sm-8">: {{ optional($home->mooban)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">บ้านเลขที่</div>
				<div class="col-sm-8">: {{ $home->address }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ผู้บันทึกข้อมูล</div>
				<div class="col-sm-8">: {{ optional($home->user)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $home->created_at }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $home->updated_at }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">หมายเหตุ</div>
				<div class="col-sm-8">: {{ $home->remark }}</div>
			</div>

        

    </div>
</div>

@endsection