<!DOCTYPE html>
<html lang="en"> 
<head>
    <title>{{ env('APP_NAME') }}</title>
    
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta name="description" content="{{ env('APP_NAME') }}">
    <meta name="author" content="Xiaoying Riley at 3rd Wave Media">    
    <link rel="shortcut icon" href="favicon.ico"> 
    
    <!-- FontAwesome JS-->
    <script defer src="{{asset('assets/plugins/fontawesome/js/all.min.js')}}"></script>
    
    <!-- App CSS -->  
    <link id="theme-style" rel="stylesheet" href="{{asset('assets/css/portal.css')}}">
<style>
	.app-auth-wrapper .app-auth-body {
    width: 560px;
}
</style>
</head> 

<body class="app app-login p-0">    	
    <div class="row g-0 app-auth-wrapper justify-content-md-center">
	    <div class="col-12 auth-main-col text-center p-5">
		    <div class="d-flex flex-column align-content-end">
			    <div class="app-auth-body mx-auto">	
				    <div class="app-auth-branding mb-4"><a class="app-logo" href="{{ route('home') }}"><img class="logo-icon me-2" src="{{asset('assets/images/app-logo.png')}}" alt="logo"></a></div>
					<h2 class="auth-heading text-center mb-5">{{ env('APP_NAME') }}</h2>
			        <div class="auth-form-container text-start">
                        @yield('content')
						  {{-- <form class="auth-form login-form" method="POST" action="{{ route('login') }}">
							@csrf
                            <div class="email mb-3">
								<label class="sr-only" for="signin-email">{{ __('Username') }}</label>
								<input id="email" type="text" placeholder="{{ __('E-Mail Address') }}" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
							</div><!--//form-group-->
							<div class="password mb-3">
								<label class="sr-only" for="signin-password">Password</label>
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
								<div class="extra mt-3 row justify-content-between">
									<div class="col-6">
										<div class="form-check">
											<input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
											<label class="form-check-label" for="RememberPassword">
                                                {{ __('Remember Me') }}
											</label>
										</div>
									</div><!--//col-6-->
									<div class="col-6">
										<div class="forgot-password text-end">
                                            @if (Route::has('password.request'))
                                                <a  href="{{ route('password.request') }}">
                                                    {{ __('Forgot Your Password?') }}
                                                </a>
                                            @endif
										</div>
									</div><!--//col-6-->
								</div><!--//extra-->
							</div><!--//form-group-->
							<div class="text-center">
								<button type="submit" class="btn app-btn-primary w-100 theme-btn mx-auto">
                                    {{ __('Login') }}
                                </button>
							</div>
						</form> --}}
						
					</div><!--//auth-form-container-->	

			    </div><!--//auth-body-->
		    
			<!--    <footer class="app-auth-footer">
				    <div class="container text-center py-3">
				         <small class="copyright">Thanks for theme<span class="sr-only">love</span><i class="fas fa-heart"
							style="color: #fb866a;"></i> by
						<a class="app-link" href="http://themes.3rdwavemedia.com" target="_blank">Xiaoying Riley</a> Dev by
						<a href="//nokhookstudio.com/">Nokhook studio</a></small>
				    </div>
			    </footer>--><!--//app-auth-footer-->	
		    </div><!--//flex-column-->   
	    </div><!--//auth-main-col-->
	    <!--//auth-background-col-->
    
    </div><!--//row-->


</body>
</html> 