
<div class="form-group row {{ $errors->has('people_id') ? 'has-error' : '' }}">
    <label for="people_id" class="col-md-2 control-label">บุคคล</label>
    <div class="col-md-4">
        <select class="form-control" id="people_id" name="people_id">
        	    <option value="" style="display: none;" {{ old('people_id', optional($leaderAssessment)->people_id ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ บุคคล</option>
        	@foreach ($people as $key => $person)
			    <option value="{{ $key }}" {{ old('people_id', optional($leaderAssessment)->people_id) == $key ? 'selected' : '' }}>
			    	{{ $person }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('people_id', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('assessment_date') ? 'has-error' : '' }}">
    <label for="assessment_date" class="col-md-2 control-label">วันที่ประเมิน</label>
    <div class="col-md-4">
        <input class="form-control" name="assessment_date" type="text" id="assessment_date" value="{{ old('assessment_date', optional($leaderAssessment)->assessment_date) }}" placeholder="ระบุ วันที่ประเมิน">
        {!! $errors->first('assessment_date', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('assessment_period') ? 'has-error' : '' }}">
    <label for="assessment_period" class="col-md-2 control-label">ครั้งที่ประเมิน</label>
    <div class="col-md-4">
        <input class="form-control" name="assessment_period" type="text" id="assessment_period" value="{{ old('assessment_period', optional($leaderAssessment)->assessment_period) }}" min="-32768" max="32767" placeholder="ระบุ ครั้งที่ประเมิน">
        {!! $errors->first('assessment_period', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('expression') ? 'has-error' : '' }}">
    <label for="expression" class="col-md-2 control-label">การแสดงออกทางการเมือง</label>
    <div class="col-md-4">
        <select class="form-control" id="expression" name="expression">
        	    <option value="" style="display: none;" {{ old('expression', optional($leaderAssessment)->expression ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ การแสดงออกทางการเมือง</option>
        	@foreach (['3' => '3',
'2' => '2',
'1' => '1'] as $key => $text)
			    <option value="{{ $key }}" {{ old('expression', optional($leaderAssessment)->expression) == $key ? 'selected' : '' }}>
			    	{{ $text }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('expression', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('performance') ? 'has-error' : '' }}">
    <label for="performance" class="col-md-2 control-label">ขีดความสามารถการแสดงออก</label>
    <div class="col-md-4">
        <select class="form-control" id="performance" name="performance">
        	    <option value="" style="display: none;" {{ old('performance', optional($leaderAssessment)->performance ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ขีดความสามารถการแสดงออก</option>
        	@foreach (['3' => '3',
'2' => '2',
'1' => '1'] as $key => $text)
			    <option value="{{ $key }}" {{ old('performance', optional($leaderAssessment)->performance) == $key ? 'selected' : '' }}>
			    	{{ $text }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('performance', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('dependability') ? 'has-error' : '' }}">
    <label for="dependability" class="col-md-2 control-label">บารมี/ความน่าเชื่อถือ</label>
    <div class="col-md-4">
        <select class="form-control" id="dependability" name="dependability">
        	    <option value="" style="display: none;" {{ old('dependability', optional($leaderAssessment)->dependability ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ บารมี/ความน่าเชื่อถือ</option>
        	@foreach (['3' => '3',
'2' => '2',
'1' => '1'] as $key => $text)
			    <option value="{{ $key }}" {{ old('dependability', optional($leaderAssessment)->dependability) == $key ? 'selected' : '' }}>
			    	{{ $text }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('dependability', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('associate') ? 'has-error' : '' }}">
    <label for="associate" class="col-md-2 control-label">ฝักไฝ่ฝ่ายเรา</label>
    <div class="col-md-4">
        <select class="form-control" id="associate" name="associate">
        	    <option value="" style="display: none;" {{ old('associate', optional($leaderAssessment)->associate ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ฝักไฝ่ฝ่ายเรา</option>
        	@foreach (['3' => '3',
'2' => '2',
'1' => '1'] as $key => $text)
			    <option value="{{ $key }}" {{ old('associate', optional($leaderAssessment)->associate) == $key ? 'selected' : '' }}>
			    	{{ $text }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('associate', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('users_id') ? 'has-error' : '' }}">
    <label for="users_id" class="col-md-2 control-label">ผู้บันทึกข้อมูล</label>
    <div class="col-md-4">
        <select class="form-control" id="users_id" name="users_id">
        	    <option value="" style="display: none;" {{ old('users_id', optional($leaderAssessment)->users_id ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ผู้บันทึกข้อมูล</option>
        	@foreach ($users as $key => $user)
			    <option value="{{ $key }}" {{ old('users_id', optional($leaderAssessment)->users_id) == $key ? 'selected' : '' }}>
			    	{{ $user }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('users_id', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

