@extends('layouts.app')

@section('content')

    @if(Session::has('success_message'))
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            {!! session('success_message') !!}

            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    @endif

    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">Leader Assessments</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="{{ route('leader_assessments.leader_assessment.create') }}" class="btn btn-success" title="เพิ่ม Leader Assessment ใหม่">                     
					<i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>
        
        @if(count($leaderAssessments) == 0)
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล Leader Assessments</h4>
            </div>
        @else
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                        <tr>
						<th>ลำดับที่</th>
                                <th>บุคคล</th>
                            <th>วันที่ประเมิน</th>
                            <th>ครั้งที่ประเมิน</th>
                            <th>การแสดงออกทางการเมือง</th>
                            <th>ขีดความสามารถการแสดงออก</th>
                            <th>บารมี/ความน่าเชื่อถือ</th>
                            <th>ฝักไฝ่ฝ่ายเรา</th>
                            <th>ผู้บันทึกข้อมูล</th>

                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
					 <?php $r = 0 ; if(isset($_REQUEST['page']) && $_REQUEST['page'] > 1 ){$r = 25 * ($_REQUEST['page']-1);}?>
                    @foreach($leaderAssessments as $leaderAssessment)
                        <tr>
						<td>{{++$r}}</td>
						
                                <td>{{ optional($leaderAssessment->person)->name }}</td>
                            <td>{{ $leaderAssessment->assessment_date }}</td>
                            <td>{{ $leaderAssessment->assessment_period }}</td>
                            <td>{{ $leaderAssessment->expression }}</td>
                            <td>{{ $leaderAssessment->performance }}</td>
                            <td>{{ $leaderAssessment->dependability }}</td>
                            <td>{{ $leaderAssessment->associate }}</td>
                            <td>{{ optional($leaderAssessment->user)->name }}</td>

                            <td>

                                <form method="POST" action="{!! route('leader_assessments.leader_assessment.destroy', $leaderAssessment->id) !!}" accept-charset="UTF-8">
                                <input name="_method" value="DELETE" type="hidden">
                                {{ csrf_field() }}

                                    <div class="btn-group btn-group-sm float-right" role="group">
                                        <a href="{{ route('leader_assessments.leader_assessment.show', $leaderAssessment->id ) }}" class="btn btn-info" title="แสดงข้อมูล Leader Assessment">
                                            <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                        </a>
                                        <a href="{{ route('leader_assessments.leader_assessment.edit', $leaderAssessment->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล Leader Assessment">
                                            <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                        </a>

                                        <button type="submit" class="btn btn-danger" title="ลบ Leader Assessment ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ Leader Assessment ')">
                                            <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                        </button>
                                    </div>

                                </form>
                                
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>
        </div>

        <div class="card-footer">
            {!! $leaderAssessments->render() !!}
        </div>
        
        @endif
    
    </div>
@endsection