@extends('layouts.app')

@section('content')

    @if (Session::has('success_message'))
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            {!! session('success_message') !!}

            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    @endif

    <div class="card">

        <div class="card-body">
            <form class="row g-3 justify-content-md-center">


                <div class="col-auto">
                    <label for="amphurs_id" class="col-form-label">อำเภอ</label>
                </div>

                <div class="col-auto">
                    <select class="form-control" id="amphurs_id" name="amphurs_id" onChange="get_tambons(this.value)"
                         >
                        <option value=""     selected>
                            ระบุ อำเภอ
                        </option>

                        @foreach ($amphurs as $key => $amphur)
                            <option value="{{ $key }}"
                                {{ Request::input('amphurs_id') == $key ? 'selected' : '' }}>
                                {{ $amphur }}
                            </option>
                        @endforeach
                    </select>
                </div>

  <div class="col-auto">
                    <label for="tambons_id" class="col-form-label">ตำบล</label>
                </div>

       <div class="col-auto">
<select class="form-control" id="tambons_id" name="tambons_id" onChange="get_moobans(this.value )"  >
        	    <option value="" style="display: none;"      selected>ระบุ  ตำบล</option>
        	@foreach ($tambons as $key => $tambon)
			    <option value="{{ $key }}"  {{  Request::input('tambons_id') == $key ? 'selected' : '' }}>
			    	{{ $tambon }}
			    </option>
			@endforeach
        </select>
       </div>


                <div class="col-auto">
                    <button type="submit" class="btn btn-primary mb-3">ค้นหา</button>
                </div>
            </form>
        </div>



    </div>


    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5 class="my-1 float-left">หมู่บ้าน</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="{{ route('moobans.mooban.create') }}" class="btn btn-success" title="เพิ่ม หมู่บ้าน ใหม่">
                    <i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>

        @if (count($moobans) == 0)
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล หมู่บ้าน</h4>
            </div>
        @else
            <div class="card-body">

                <div class="table-responsive">
                    <table class="table table-striped table-sm table-bordered">
                        <thead>
                            <tr>
                                <th>ลำดับที่</th>

                                <th>ชื่อหมู่บ้าน</th>
                                <th>หมู่ที่</th>
                                <th>ตำบล</th>
                                <th>อำเภอ</th>
                                <th>จำนวนผู้มาใช้สิทธิเลือกตั้งที่ผ่านมา</th>
                                <th>จำนวนผู้มีสิทธิเลือกตั้ง</th>
                                <th>ประชากรรวม</th>
                                <th>จำนวนหลังคาเรือน</th>
                                <th>ละติจูด</th>
                                <th>ลองจิจูด</th>

                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $r = 0;
                            if (isset($_REQUEST['page']) && $_REQUEST['page'] > 1) {
                                $r = 25 * ($_REQUEST['page'] - 1);
                            } ?>
                            @foreach ($moobans as $mooban)
                                <tr>
                                    <td>{{ ++$r }}</td>


                                    <td>{{ $mooban->name }}</td>
                                    <td>{{ $mooban->moo }}</td>
                                    <td>{{ optional($mooban->tambon)->name }}</td>
                                    <td>{{ optional($mooban->tambon->amphur)->name_th }}</td>
                                    <td>{{ $mooban->last_voter }}</td>
                                    <td>{{ $mooban->voter_num }}</td>
                                    <td>{{ $mooban->total_pop }}</td>
                                    <td>{{ $mooban->total_house }}</td>
                                    <td>{{ $mooban->latitude }}</td>
                                    <td>{{ $mooban->longitude }}</td>

                                    <td>

                                        <form method="POST" action="{!! route('moobans.mooban.destroy', $mooban->id) !!}" accept-charset="UTF-8">
                                            <input name="_method" value="DELETE" type="hidden">
                                            {{ csrf_field() }}

                                            <div class="btn-group btn-group-sm float-right" role="group">
                                                <a href="{{ route('moobans.mooban.show', $mooban->id) }}"
                                                    class="btn btn-info" title="แสดงข้อมูล หมู่บ้าน">
                                                    <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                                </a>
                                                <a href="{{ route('moobans.mooban.edit', $mooban->id) }}"
                                                    class="btn btn-primary" title="แก้ไขข้อมูล หมู่บ้าน">
                                                    <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                                </a>

                                                <button type="submit" class="btn btn-danger" title="ลบ หมู่บ้าน ทิ้ง"
                                                    onclick="return confirm('คลิก OK เพื่อยืนยันการลบ หมู่บ้าน ')">
                                                    <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                                </button>
                                            </div>

                                        </form>

                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>

            <div class="card-footer">
                {!! $moobans->render() !!}
            </div>
        @endif

    </div>
@endsection

@section('script')

    <script>
        function get_tambons(  amphurs_id  )
{	 
	 $.ajax({ 
			type: 'POST', 
			url: "{{route('tambons.tambon.get_tambon_by_amphur',0)}}"+amphurs_id, 
			data: {_token:'{{csrf_token()}}' }, 
			dataType: 'text',
			success: function (data) 
				 {				
				   $('#tambons_id' ).html('');
					$('#tambons_id' ).append(data);
				 }
			})
}
</script>
@stop