@extends('layouts.app')

@section('content')

    @if(Session::has('success_message'))
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            {!! session('success_message') !!}

            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    @endif

    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">ผู้มีสิทธิ์เลือกตั้ง</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="{{ route('people.people.create') }}" class="btn btn-success" title="เพิ่ม ผู้มีสิทธิ์เลือกตั้ง ใหม่">                     
					<i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>
        
        @if(count($peopleObjects) == 0)
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล ผู้มีสิทธิ์เลือกตั้ง</h4>
            </div>
        @else
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                        <tr>
						<th>ลำดับที่</th>
                                <th>เลขบัตรประชาชน</th>
                            <th>บ้านเลขที่</th>
                            <th>หมู่บ้าน</th>
                              <th>หมู่ที่</th>
                              <th>ตำบล</th>
                                <th>อำเภอ</th>  <th>ภาพ</th>
                           
                            <th>ชื่อ-สกุล</th> 
                            <th>เพศ</th>
                            <th>ปีเกิด</th>
                            <th>อายุ</th>
                            <th>เบอร์โทร</th>
                            <th>ตำแหน่ง/ยศ</th>
                            <th>ระดับการศึกษา</th>
                            <th>ถิ่นที่อยู่</th>
                            <th>กรณีนอกพื้นที่ (ถ้ามี)</th>
                            <th>การเลือกตั้งในเขต</th>
                            <th>ฝ่าย</th>
                          
                            <th>ผู้บันทึกข้อมูล</th>
                            <th>ผู้รับผิดชอบในการหาเสียง</th>
                            <th>คำอธิบาย บุคคลเพิ่มเติม</th>
                            <th>ละติจูด</th>
                            <th>ลองจิจูด</th>

                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
					 <?php $r = 0 ; if(isset($_REQUEST['page']) && $_REQUEST['page'] > 1 ){$r = 25 * ($_REQUEST['page']-1);}?>
                    @foreach($peopleObjects as $people)
                        <tr>
						<td>{{++$r}}</td>
						
                                <td>{{ $people->idcard }}</td>
                            <td>{{ optional($people->home)->address }}</td>
                            <td>{{ optional($people->mooban)->name }}</td>
                              <td>{{ optional($people->mooban)->moo }}</td>
                                 <td>{{ optional($people->mooban->tambon)->name }}</td>
                                      <td>{{ optional($people->mooban->tambon->amphur)->name_th }}</td>
                             <td><img src="{{ asset($people->image )}}" style="width: 50px"></td>
                            <td>{{ $people->name }}</td>
                              <td>{{ $people->gender }}</td>
                            <td>{{ $people->born }}</td>
                            <td>{{ $people->age }}</td>
                            <td>{{ $people->tel }}</td>
                            <td>{{ optional($people->position)->name }}</td>
                            <td>{{ optional($people->education)->name }}</td>
                            <td>{{ $people->residence }}</td>
                            <td>{{ $people->residence_detail }}</td>
                            <td>{{ $people->vote_location }}</td>
                            <td>{{ optional($people->associate)->name }}</td>
                         
                            <td>{{ optional($people->user)->name }}</td>
                            <td>{{ optional($people->trackingUser)->id }}</td>
                            <td>{{ $people->etc }}</td>
                            <td>{{ $people->lat }}</td>
                            <td>{{ $people->lon }}</td>

                            <td>

                                <form method="POST" action="{!! route('people.people.destroy', $people->id) !!}" accept-charset="UTF-8">
                                <input name="_method" value="DELETE" type="hidden">
                                {{ csrf_field() }}

                                    <div class="btn-group btn-group-sm float-right" role="group">
                                        <a href="{{ route('people.people.show', $people->id ) }}" class="btn btn-info" title="แสดงข้อมูล ผู้มีสิทธิ์เลือกตั้ง">
                                            <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                        </a>
                                        <a href="{{ route('people.people.edit', $people->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล ผู้มีสิทธิ์เลือกตั้ง">
                                            <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                        </a>

                                        <button type="submit" class="btn btn-danger" title="ลบ ผู้มีสิทธิ์เลือกตั้ง ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ ผู้มีสิทธิ์เลือกตั้ง ')">
                                            <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                        </button>
                                    </div>

                                </form>
                                
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>
        </div>

        <div class="card-footer">
            {!! $peopleObjects->render() !!}
        </div>
        
        @endif
    
    </div>
@endsection