@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($tambon->name) ? $tambon->name : 'ตำบล' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('tambons.tambon.destroy', $tambon->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('tambons.tambon.index') }}" class="btn btn-primary" title="แสดง ตำบล ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('tambons.tambon.create') }}" class="btn btn-success" title="เพิ่ม ตำบล ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('tambons.tambon.edit', $tambon->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล ตำบล">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ ตำบล ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ ตำบล ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">รหัสอำเภอ</div>
				<div class="col-sm-8">: {{ optional($tambon->amphur)->name_th }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ชื่อตำบล(ไทย)</div>
				<div class="col-sm-8">: {{ $tambon->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">เขตเลือกตั้ง</div>
				<div class="col-sm-8">: {{ optional($tambon->electorate)->name }}</div>
			</div>

        

    </div>
</div>

@endsection