@extends('layouts.app')

@section('content')

    @if(Session::has('success_message'))
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            {!! session('success_message') !!}

            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    @endif

    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">ผู้ใช้งานระบบ</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="{{ route('users.user.create') }}" class="btn btn-success" title="เพิ่ม ผู้ใช้งานระบบ ใหม่">                     
					<i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>
        
        @if(count($users) == 0)
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล ผู้ใช้งานระบบ</h4>
            </div>
        @else
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                        <tr>
						<th>ลำดับที่</th>   <th>ภาพโปรไฟล์</th>
                                <th>ชื่อ-สกุล</th>
                            <th>เบอร์โทร</th>
                            <th>E-mail</th>
                            <th>ผู้ใช้งานระบบname</th>
                            <th>สิทธิ์</th>
                         
                            <th>ควบคุมหมู่บ้าน</th>
                            <th>ควบคุมตำบล</th>
                            <th>ควบคุมอำเภอ</th>
                            <th>ควบคุมเขตเลือกตั้ง</th>

                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
					 <?php $r = 0 ; if(isset($_REQUEST['page']) && $_REQUEST['page'] > 1 ){$r = 25 * ($_REQUEST['page']-1);}?>
                    @foreach($users as $user)
                        <tr>
						<td>{{++$r}}</td>
						  <td><img src="{{ asset(  $user->image  ) }}" style="width: 70px"></td>
                                <td>{{ $user->name }}</td>
                            <td>{{ $user->tel }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->username }}</td>
                            <td>{{ $user->permission }}</td>
                           
                            <td>{{ optional($user->mooban)->name }}</td>
                            <td>{{ optional($user->tambon)->name }}</td>
                            <td>{{ optional($user->amphur)->name_th }}</td>
                            <td>{{ optional($user->electorate)->name }}</td>

                            <td>

                                <form method="POST" action="{!! route('users.user.destroy', $user->id) !!}" accept-charset="UTF-8">
                                <input name="_method" value="DELETE" type="hidden">
                                {{ csrf_field() }}

                                    <div class="btn-group btn-group-sm float-right" role="group">
                                        <a href="{{ route('users.user.show', $user->id ) }}" class="btn btn-info" title="แสดงข้อมูล ผู้ใช้งานระบบ">
                                            <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                        </a>
                                        <a href="{{ route('users.user.edit', $user->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล ผู้ใช้งานระบบ">
                                            <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                        </a>

                                        <button type="submit" class="btn btn-danger" title="ลบ ผู้ใช้งานระบบ ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ ผู้ใช้งานระบบ ')">
                                            <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                        </button>
                                    </div>

                                </form>
                                
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>
        </div>

        <div class="card-footer">
            {!! $users->render() !!}
        </div>
        
        @endif
    
    </div>
@endsection