@extends('layouts.app')

@section('content')

    @if(Session::has('success_message'))
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            {!! session('success_message') !!}

            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    @endif

    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">Voter Assessments</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="{{ route('voter_assessments.voter_assessment.create') }}" class="btn btn-success" title="เพิ่ม Voter Assessment ใหม่">                     
					<i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>
        
        @if(count($voterAssessments) == 0)
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล Voter Assessments</h4>
            </div>
        @else
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                        <tr>
						<th>ลำดับที่</th>
                                <th>บุคคล</th>
                            <th>วันที่ประเมิน</th>
                            <th>ครั้งที่ประเมิน</th>
                            <th>โอกาสได้คะแนน</th>
                            <th>เบอร์ที่คาดว่าจะให้คะแนน</th>
                            <th>พรรคที่คาดว่าจะให้คะแนน</th>
                            <th>ผู้บันทึกข้อมูล</th>
                            <th></th>

                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
					 <?php $r = 0 ; if(isset($_REQUEST['page']) && $_REQUEST['page'] > 1 ){$r = 25 * ($_REQUEST['page']-1);}?>
                    @foreach($voterAssessments as $voterAssessment)
                        <tr>
						<td>{{++$r}}</td>
						
                                <td>{{ optional($voterAssessment->person)->name }}</td>
                            <td>{{ $voterAssessment->assessment_date }}</td>
                            <td>{{ $voterAssessment->assessment_period }}</td>
                            <td>{{ $voterAssessment->score }}</td>
                            <td>{{ $voterAssessment->target_number }}</td>
                            <td>{{ optional($voterAssessment->associate)->name }}</td>
                            <td>{{ optional($voterAssessment->user)->name }}</td>
                            <td>{{ $voterAssessment->selected }}</td>

                            <td>

                                <form method="POST" action="{!! route('voter_assessments.voter_assessment.destroy', $voterAssessment->id) !!}" accept-charset="UTF-8">
                                <input name="_method" value="DELETE" type="hidden">
                                {{ csrf_field() }}

                                    <div class="btn-group btn-group-sm float-right" role="group">
                                        <a href="{{ route('voter_assessments.voter_assessment.show', $voterAssessment->id ) }}" class="btn btn-info" title="แสดงข้อมูล Voter Assessment">
                                            <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                        </a>
                                        <a href="{{ route('voter_assessments.voter_assessment.edit', $voterAssessment->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล Voter Assessment">
                                            <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                        </a>

                                        <button type="submit" class="btn btn-danger" title="ลบ Voter Assessment ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ Voter Assessment ')">
                                            <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                        </button>
                                    </div>

                                </form>
                                
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>
        </div>

        <div class="card-footer">
            {!! $voterAssessments->render() !!}
        </div>
        
        @endif
    
    </div>
@endsection